############################################################################
########################	   function define       #######################
############################################################################
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

############################################################################
#########################	   read in data       ##########################
############################################################################

HM_promoter_signal <- read.table("../data/hm.average.signal.on.promoter.2nd.K4.txt",row.names=1)
colnames(HM_promoter_signal) <- c("hiF_K4me2","hiF_K4me3","he6_K4me2","he6_K4me3","n24p_K4me2","n24p_K4me3","niPS_K4me2","niPS_K4me3","p24p_K4me2","p24p_K4me3","piPS_K4me2","piPS_K4me3")
n_K4me3_path <- c("hiF_K4me3","he6_K4me3","n24p_K4me3","niPS_K4me3")

## 2nd naive RNAseq
logfpkm2nd <- read.table("../data/2nd.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
n_path <- c("hiF_r1","hiF_r2","he0_r1","he0_r2","he2_r1","he2_r2","he6_r1","he6_r2","n8_r1","n8_r2","n8_r3","n12_r1","n12_r2","n14_r1","n14_r2","n14_r3","n20_r1","n20_r2","n20_r3","n24p_r1","n24p_r2","n24m_r1","n24m_r2","niPS_r1","niPS_r2")
nData_tmp <- logfpkm2nd[,n_path]
nfpkm2nd <- 2**nData_tmp - 1

n_time_point <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24p","n24m","niPS")
n_label <- c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T")
nData2ndfpkm <- cbind(apply(nfpkm2nd[,1:2],1,mean),apply(nfpkm2nd[,3:4],1,mean),apply(nfpkm2nd[,5:6],1,mean),apply(nfpkm2nd[,7:8],1,mean),apply(nfpkm2nd[,9:11],1,mean),apply(nfpkm2nd[,12:13],1,mean),apply(nfpkm2nd[,14:16],1,mean),apply(nfpkm2nd[,17:19],1,mean),apply(nfpkm2nd[,20:21],1,mean),apply(nfpkm2nd[,22:23],1,mean),apply(nfpkm2nd[,24:25],1,mean))
colnames(nData2ndfpkm) <- n_time_point
rownames(nData2ndfpkm) <- rownames(nfpkm2nd)
nData <- log2(nData2ndfpkm+1)

## 2nd naive DNA methylation ratio on promoter
methyratio_promoter <- read.table("../data/2nd_average_methratio_on_promoter.txt",header=T,row.names=1)
hiFT <- methyratio_promoter[,"hiFT"]
he6 <- methyratio_promoter[,"he6"]
n12 <- apply(methyratio_promoter[,c("n12","n12_r2")],1,mean,na.rm=TRUE)
n20 <- methyratio_promoter[,"n20"]
n24 <- methyratio_promoter[,"n24"]
niPS <- methyratio_promoter[,"niPS"]
methyratio_promoter <- cbind(hiFT,he6,n12,n20,n24,niPS)
methy_n_path <- c("hiFT","he6","n12","n20","n24","niPS")
methy_n_label <- c("hiF-T","6d","12d","20d","24d+dox","niPSC-T")

############ genes
C1_methylated <- c("CAV2", "COL7A1")
C1_H3K4me3 <- c("IGFBP6", "COL1A2")

# C9_methylated <- c("ALCAM", "DISP1")
C9_methylated <- c("S100A16","ATP1A2","SERTAD4","GYPC","RABL3","LEKR1","CCNG2","SPCS3","FBN2","RGMB","CEP57L1","KIAA1324L","MMP16","ACSL4","AKR1E2","LPXN","TMEM123","PYROXD1","FOXO1","PCNXL4","SNX1","RBL2")
# C9_H3K4me3 <- c("COL5A2", "ANXA1") # COL5A2 in c10
C9_H3K4me3 <- c("ANXA1")

C20_methylated <- c("DPPA4")
C20_H3K4me3 <- c("EPCAM","ZNF280A")

C17_methylated <- c("TFCP2L1", "DNMT3L", "NLRP2")
C17_H3K4me3 <- c("DPPA2", "DPPA3", "LIN28A")

ME_genes <- c("CAV2","COL7A1","ALCAM","MMP16","DPPA4","TFCP2L1","DNMT3L","NLRP2","FZD5","CD200")
HM_genes <- c("IGFBP6","COL1A2","COL5A2","ANXA1","EPCAM","ZNF280A","DPPA2","DPPA3","LIN28A")
EARLY <- c("PPP1R12B","SRM","SH3D21","ZNF326","C1orf115","FZD5","DPPA4","CD200","ST6GAL1","HYAL1","ESRG","NCBP2-AS2","WIPF3","ESRP1","EPPK1","AUH","PBX3","AQP3","FAM69B","PHKA1","SLC25A16","FAM213A","IFITM1","GAL","PLBD1","B4GALNT3","FGD4","SCNN1A","YEATS4","PPP1CC","SYNE2","COCH","RAB15","MT1A","RAB11FIP4","AKAP1","ARHGEF15","FASN","DSG3","C2CD4C","TNFSF9","TUBB4A","PRODH","SUSD2")

############################################################################
#########################	       plot           ##########################
############################################################################

Fig6A_2_HM <- function(genes){
	for (each in genes){
		exp <- nData[each,]
		exp_max <- max(exp)
		exp_min <- min(exp)
		HM_max <- max(HM_promoter_signal[each,n_K4me3_path])
		HM_min <- min(HM_promoter_signal[each,n_K4me3_path])
		lambda <- (exp_max-exp_min)/(HM_max-HM_min)
		b <- (exp_min*HM_max-exp_max*HM_min)/(HM_max-HM_min)
		par(mar=c(6,4,4,4))
		plot(exp,main=each,type="l",lwd=3,col="black",ylab="log2(fpkm+1)",xlab="",las=2,xaxt="n",ylim=c(exp_min,exp_max))
		axis(side=1,1:length(n_time_point),n_label,las=2);
		points(c(1,4,9,11),lambda*(HM_promoter_signal[each,n_K4me3_path])+b,type="l",lwd=3,col=cccol[1])
		axis(side=4,lambda*c(HM_min,(HM_max+HM_min)/2,HM_max)+b,round(c(HM_min,(HM_max+HM_min)/2,HM_max),2),las=2)
		mtext("Reads per million", side=4, line=2.6)
		# legend("topleft",c("Gene expression"),col="black",lwd=3,bty="n")
		# legend("topright",c("H3K4me3"),col=cccol,lwd=3,bty="n")
	}
}
Fig6A_2_ME <- function(genes){
	for (each in genes){
		exp <- nData[each,]
		exp_max <- max(exp)
		exp_min <- min(exp)
		ME_max <- max(na.omit(methyratio_promoter[each,methy_n_path]))
		ME_min <- min(na.omit(methyratio_promoter[each,methy_n_path]))
		lambda <- (exp_max-exp_min)/(ME_max-ME_min)
		b <- (exp_min*ME_max-exp_max*ME_min)/(ME_max-ME_min)
		par(mar=c(6,4,4,4))
		plot(exp,main=each,type="l",lwd=3,col="black",ylab="log2(fpkm+1)",xlab="",las=2,xaxt="n",ylim=c(exp_min,exp_max))
		axis(side=1,1:length(n_time_point),n_label,las=2);
		points(c(1,4,6,8,9,11),lambda*(methyratio_promoter[each,methy_n_path])+b,type="l",lwd=3,col=cccol[2])
		axis(side=4,lambda*c(ME_min,(ME_max+ME_min)/2,ME_max)+b,round(c(ME_min,(ME_max+ME_min)/2,ME_max),2),las=2)
		mtext("Methylation ratio", side=4, line=2.6)
		# legend("topleft",c("Gene expression"),col="black",lwd=3,bty="n")
		# legend("topright",c("Methylation ratio"),col=cccol[2],lwd=3,bty="n")	
	}
}


pdf("Fig6A_2.pdf",,width=4.2,height=3.6)
Fig6A_2_HM(HM_genes)
Fig6A_2_ME(ME_genes)
plot(1,1,type="n",xaxt="n",yaxt="n",xlab="",ylab="",bty="n")
legend("topleft",c("Gene expression","H3K4me3","Methylation ratio"),col=c("black",cccol[1],cccol[2]),lwd=3,bty="n")
dev.off()

pdf("C9_methylated.pdf",,width=4.2,height=3.6)
Fig6A_2_ME(C9_methylated)
plot(1,1,type="n",xaxt="n",yaxt="n",xlab="",ylab="",bty="n")
legend("topleft",c("Gene expression","H3K4me3","Methylation ratio"),col=c("black",cccol[1],cccol[2]),lwd=3,bty="n")
dev.off()

# pdf("early_embryogenesis.pdf",,width=4.2,height=3.6)
# Fig6A_2_ME(EARLY)
# plot(1,1,type="n",xaxt="n",yaxt="n",xlab="",ylab="",bty="n")
# legend("topleft",c("Gene expression","H3K4me3","Methylation ratio"),col=c("black",cccol[1],cccol[2]),lwd=3,bty="n")
# dev.off()